package gov.va.med.mhv.calendar.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Id;


@Entity
@Table(name = "REMINDER_SCHEDULE")
public class ReminderSchedule implements Serializable {

	private static final long serialVersionUID = 6631127829987172777L;

	@Id
	@Column(name = "REMINDER_SCHEDULE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "NAME")
	private String name;
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "REMINDER_SCHEDULE_TYPE_ID")
	private ReminderScheduleType reminderScheduleType;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public ReminderScheduleType getReminderScheduleType() {
		return reminderScheduleType;
	}

	public void setReminderScheduleType(ReminderScheduleType reminderScheduleType) {
		this.reminderScheduleType = reminderScheduleType;
	}

}
